<?php
include 'config.php';

// Receive filters
$keyword    = isset($_GET['keyword']) ? trim($_GET['keyword']) : "";
$brand      = isset($_GET['brand']) ? trim($_GET['brand']) : "";
$model      = isset($_GET['model']) ? trim($_GET['model']) : "";
$min_price  = isset($_GET['min_price']) ? intval($_GET['min_price']) : 0;
$max_price  = isset($_GET['max_price']) ? intval($_GET['max_price']) : 999999999;
$min_year   = isset($_GET['min_year']) ? intval($_GET['min_year']) : 0;
$max_year   = isset($_GET['max_year']) ? intval($_GET['max_year']) : 9999;
$seller     = isset($_GET['seller']) ? trim($_GET['seller']) : "";

// Build SQL query safely
$sql = "SELECT * FROM cars WHERE 1=1";
$params = [];
$types  = "";

// Keyword
if (!empty($keyword)) {
    $sql .= " AND (brand LIKE ? OR model LIKE ? OR description LIKE ?)";
    $kw = "%$keyword%";
    $params[] = $kw; $types .= "s";
    $params[] = $kw; $types .= "s";
    $params[] = $kw; $types .= "s";
}

// Brand
if (!empty($brand)) {
    $sql .= " AND brand = ?";
    $params[] = $brand; $types .= "s";
}

// Model
if (!empty($model)) {
    $sql .= " AND model = ?";
    $params[] = $model; $types .= "s";
}

// Price range
$sql .= " AND price BETWEEN ? AND ?";
$params[] = $min_price; $types .= "i";
$params[] = $max_price; $types .= "i";

// Year filter
$sql .= " AND year BETWEEN ? AND ?";
params[] = $min_year; $types .= "i";
$params[] = $max_year; $types .= "i";

// Seller type
if (!empty($seller)) {
    $sql .= " AND seller_type = ?";
    $params[] = $seller; $types .= "s";
}

// final
$sql .= " ORDER BY id DESC";

$stmt = $conn->prepare($sql);

// Bind dynamically
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Search Results - Car Marketplace</title>
<link rel="stylesheet" href="style.css">

<style>
/* Search Page UI */
.search-header {
    background: #fff;
    padding: 15px;
    border-bottom: 1px solid #eee;
}

.cars-container {
    display: grid;
    grid-template-columns: repeat(auto-fill,minmax(170px,1fr));
    gap: 12px;
    padding: 15px;
}

.car-box {
    background: #fff;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 0 5px rgba(0,0,0,0.1);
    transition: .2s;
}

.car-box:hover {
    transform: scale(1.03);
}

.car-box img {
    width: 100%;
    height: 130px;
    object-fit: cover;
}

.car-info {
    padding: 10px;
}

.price {
    color: green;
    font-weight: bold;
}

.whatsapp-btn {
    background: #25D366;
    display: block;
    text-align: center;
    padding: 8px;
    color: #fff;
    margin: 8px auto;
    border-radius: 6px;
    text-decoration: none;
}

.no-results {
    padding: 20px;
    text-align: center;
    color: #777;
    font-size: 17px;
}
</style>
</head>
<body>

<div class="search-header">
<h2>Search Results</h2>
<p>Showing cars that match your filters.</p>
</div>

<div class="cars-container">
<?php if ($result->num_rows > 0): ?>
    <?php while ($row = $result->fetch_assoc()): ?>

        <?php
        // fetch first image
        $carId = $row['id'];
        $imgQ = $conn->query("SELECT image FROM car_images WHERE car_id=$carId LIMIT 1");
        $img = ($imgQ->num_rows) ? "uploads/".$imgQ->fetch_assoc()['image'] : "placeholder.jpg";
        ?>

        <div class="car-box">
            <a href="car.php?id=<?= $carId ?>">
                <img src="<?= $img ?>" alt="<?= $row['brand']." ".$row['model'] ?>">
            </a>

            <div class="car-info">
                <h4><?= $row['brand']." ".$row['model'] ?></h4>
                <p class="price">KES <?= number_format($row['price']) ?></p>
                <p><?= $row['year'] ?> • <?= $row['mileage'] ?> KM<br>
                Seller: <?= ucfirst($row['seller_type']) ?></p>

                <a class="whatsapp-btn"
                   href="https://wa.me/2547XXXXXXXX?text=Hello, I'm interested in the <?= $row['brand']." ".$row['model'] ?> (ID: <?= $row['id'] ?>)"
                   target="_blank">
                   WhatsApp Chat
                </a>
            </div>
        </div>

    <?php endwhile; ?>

<?php else: ?>
    <div class="no-results">No cars match your search. Try adjusting filters.</div>
<?php endif; ?>
</div>

</body>
</html>
