<?php
// public/index.php
require_once __DIR__ . '/../inc/config.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/functions.php';

$mysqli = get_db();

// Search & filters
$q = $_GET['q'] ?? '';
$brand = $_GET['brand'] ?? '';
$min_price = isset($_GET['min_price']) ? floatval($_GET['min_price']) : null;
$max_price = isset($_GET['max_price']) ? floatval($_GET['max_price']) : null;
$min_year = isset($_GET['min_year']) ? intval($_GET['min_year']) : null;
$max_year = isset($_GET['max_year']) ? intval($_GET['max_year']) : null;
$seller_type = $_GET['seller_type'] ?? '';

// Build SQL
$sql = "SELECT c.*, (SELECT filename FROM car_images ci WHERE ci.car_id = c.id AND ci.is_primary = 1 LIMIT 1) as primary_image FROM cars c WHERE 1=1";
$params = [];
$types = '';

if ($q !== '') {
    $sql .= " AND (c.title LIKE ? OR c.brand LIKE ? OR c.model LIKE ? OR c.description LIKE ?)";
    $like = "%{$q}%";
    $params[] = $like; $params[] = $like; $params[] = $like; $params[] = $like;
    $types .= 'ssss';
}
if ($brand !== '') {
    $sql .= " AND c.brand = ?";
    $params[] = $brand; $types .= 's';
}
if ($seller_type !== '') {
    $sql .= " AND c.seller_type = ?";
    $params[] = $seller_type; $types .= 's';
}
if ($min_price !== null) {
    $sql .= " AND c.price >= ?";
    $params[] = $min_price; $types .= 'd';
}
if ($max_price !== null) {
    $sql .= " AND c.price <= ?";
    $params[] = $max_price; $types .= 'd';
}
if ($min_year !== null) {
    $sql .= " AND c.year >= ?";
    $params[] = $min_year; $types .= 'i';
}
if ($max_year !== null) {
    $sql .= " AND c.year <= ?";
    $params[] = $max_year; $types .= 'i';
}

$sql .= " ORDER BY c.is_featured DESC, c.created_at DESC LIMIT 60";

$stmt = $mysqli->prepare($sql);
if ($params) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
$cars = $result->fetch_all(MYSQLI_ASSOC);

// For brand filter UI, fetch distinct brands
$brands = [];
$resb = $mysqli->query("SELECT DISTINCT brand FROM cars ORDER BY brand");
while($r = $resb->fetch_assoc()) $brands[] = $r['brand'];

?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title><?php echo e(APP_NAME); ?> - Browse Cars</title>
<link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
<header class="topbar">
  <div class="container">
    <h1 class="logo"><?php echo e(APP_NAME); ?></h1>
    <form class="search" action="index.php" method="get">
      <input name="q" value="<?php echo e($q); ?>" placeholder="Search brand, model, keyword...">
      <button type="submit">Search</button>
    </form>
  </div>
</header>

<main class="container">
  <!-- Featured slider -->
  <section class="featured-slider">
    <div class="slider">
      <?php
      $stmt2 = $mysqli->prepare("SELECT c.id, c.title, c.price, (SELECT filename FROM car_images ci WHERE ci.car_id=c.id AND ci.is_primary=1 LIMIT 1) AS img FROM cars c WHERE c.is_featured = 1 ORDER BY c.created_at DESC LIMIT 10");
      $stmt2->execute();
      $resf = $stmt2->get_result();
      while ($f = $resf->fetch_assoc()): ?>
        <div class="slide">
          <img src="<?php echo UPLOAD_URL . '/' . e($f['img'] ?: 'placeholder.png'); ?>" alt="">
          <div class="slide-caption">
            <h3><?php echo e($f['title']); ?></h3>
            <p><?php echo 'Ksh ' . number_format($f['price']); ?></p>
          </div>
        </div>
      <?php endwhile; ?>
    </div>
    <div class="slider-controls">
      <button id="prev">‹</button>
      <button id="next">›</button>
    </div>
  </section>

  <!-- Filters -->
  <aside class="filters">
    <form method="get">
      <label>Brand:
        <select name="brand">
          <option value="">All</option>
          <?php foreach($brands as $b): ?>
            <option value="<?php echo e($b); ?>" <?php if($b===$brand) echo 'selected'; ?>><?php echo e($b); ?></option>
          <?php endforeach; ?>
        </select>
      </label>
      <label>Seller:
        <select name="seller_type">
          <option value="">Any</option>
          <option value="Private" <?php if($seller_type==='Private') echo 'selected'; ?>>Private</option>
          <option value="Company" <?php if($seller_type==='Company') echo 'selected'; ?>>Company</option>
        </select>
      </label>
      <label>Price min:
        <input type="number" name="min_price" value="<?php echo e($_GET['min_price'] ?? ''); ?>">
      </label>
      <label>Price max:
        <input type="number" name="max_price" value="<?php echo e($_GET['max_price'] ?? ''); ?>">
      </label>
      <label>Year from:
        <input type="number" name="min_year" value="<?php echo e($_GET['min_year'] ?? ''); ?>">
      </label>
      <label>Year to:
        <input type="number" name="max_year" value="<?php echo e($_GET['max_year'] ?? ''); ?>">
      </label>
      <button type="submit">Apply</button>
    </form>
  </aside>

  <!-- Car list -->
  <section class="listings">
    <h2>Cars</h2>
    <div class="cards">
      <?php foreach ($cars as $car): ?>
        <article class="card <?php if($car['is_hot_deal']) echo 'hot'; ?>">
          <a href="car.php?id=<?php echo $car['id']; ?>">
            <div class="thumb">
              <img src="<?php echo UPLOAD_URL . '/' . e($car['primary_image'] ?: 'placeholder.png'); ?>" alt="<?php echo e($car['title']); ?>">
            </div>
            <div class="info">
              <h3><?php echo e($car['title']); ?></h3>
              <p class="meta"><?php echo e($car['brand'] . ' ' . $car['model'] . ' • ' . $car['year']); ?></p>
              <p class="price">Ksh <?php echo number_format($car['price']); ?></p>
            </div>
          </a>
        </article>
      <?php endforeach; ?>
      <?php if(!$cars) echo '<p>No cars found.</p>'; ?>
    </div>
  </section>

</main>

<script src="assets/js/app.js"></script>
</body>
</html>
