<?php
session_start();
include '../config.php';

// Ensure only logged-in admins can delete images
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// Validate incoming request
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid request.");
}

$image_id = intval($_GET['id']);

// Step 1: Fetch the image and its car_id
$stmt = $conn->prepare("SELECT car_id, image FROM car_images WHERE id = ?");
$stmt->bind_param("i", $image_id);
$stmt->execute();
$imgResult = $stmt->get_result();

if ($imgResult->num_rows === 0) {
    die("Image not found.");
}

$img = $imgResult->fetch_assoc();
$car_id = $img['car_id'];
$fileName = $img['image'];

// Step 2: Delete the file from server
$filePath = "../uploads/" . $fileName;

if (file_exists($filePath)) {
    unlink($filePath);
}

// Step 3: Remove image record from database
$deleteStmt = $conn->prepare("DELETE FROM car_images WHERE id = ?");
$deleteStmt->bind_param("i", $image_id);
$deleteStmt->execute();

// Step 4: Redirect back to edit page
header("Location: edit_car.php?id=" . $car_id . "&msg=Image deleted successfully");
exit;

?>
