<?php
// public/car.php
require_once __DIR__ . '/../inc/config.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/functions.php';

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if (!$id) { header('Location: index.php'); exit; }

$mysqli = get_db();
$stmt = $mysqli->prepare("SELECT * FROM cars WHERE id = ? LIMIT 1");
$stmt->bind_param('i', $id);
$stmt->execute();
$res = $stmt->get_result();
$car = $res->fetch_assoc();
if (!$car) { header('Location: index.php'); exit; }

$stmt2 = $mysqli->prepare("SELECT filename FROM car_images WHERE car_id = ? ORDER BY is_primary DESC, id ASC");
$stmt2->bind_param('i', $id);
$stmt2->execute();
$images = $stmt2->get_result()->fetch_all(MYSQLI_ASSOC);

$primary = $images[0]['filename'] ?? null;
$whatsapp_pre = "Hello, I'm interested in the car: {$car['title']} (ID:{$car['id']}). Is it still available?";
// URL encode
$wa_message = rawurlencode($whatsapp_pre);
$wa_link = "https://wa.me/2547XXXXXXXX?text={$wa_message}"; // instruct user to change the phone number
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title><?php echo e($car['title']); ?> - <?php echo e(APP_NAME); ?></title>
<link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
<header class="topbar">
  <div class="container"><a href="index.php" class="logo"><?php echo e(APP_NAME); ?></a></div>
</header>

<main class="container detail-page">
  <div class="detail-grid">
    <div class="gallery">
      <div class="main-img">
        <img id="mainImg" src="<?php echo UPLOAD_URL . '/' . e($primary ?: 'placeholder.png'); ?>" alt="">
      </div>
      <div class="thumbs">
        <?php foreach($images as $im): ?>
          <img class="thumb" src="<?php echo UPLOAD_URL . '/' . e($im['filename']); ?>" alt="">
        <?php endforeach; ?>
      </div>
    </div>

    <aside class="details">
      <h1><?php echo e($car['title']); ?></h1>
      <p class="price">Ksh <?php echo number_format($car['price']); ?></p>
      <ul class="specs">
        <li><strong>Brand:</strong> <?php echo e($car['brand']); ?></li>
        <li><strong>Model:</strong> <?php echo e($car['model']); ?></li>
        <li><strong>Year:</strong> <?php echo e($car['year']); ?></li>
        <li><strong>Mileage:</strong> <?php echo e(number_format($car['mileage'])); ?> km</li>
        <li><strong>Condition:</strong> <?php echo e($car['condition']); ?></li>
        <li><strong>Seller:</strong> <?php echo e($car['seller_type']); ?></li>
      </ul>

      <div class="actions">
        <a class="btn wa" href="<?php echo e($wa_link); ?>" target="_blank" rel="noopener">Chat via WhatsApp</a>
        <a class="btn chat" href="<?php echo e($wa_link); ?>" target="_blank" rel="noopener">Chat Now</a>
      </div>
    </aside>
  </div>

  <section class="description">
    <h3>Description</h3>
    <p><?php echo nl2br(e($car['description'])); ?></p>
  </section>
</main>

<script>
document.querySelectorAll('.thumb').forEach(t => {
  t.addEventListener('click', function(){ document.getElementById('mainImg').src = this.src; });
});
</script>
</body>
</html>
