<?php
// admin/login.php
require_once __DIR__ . '/../inc/config.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/functions.php';
$mysqli = get_db();
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = $_POST['username'] ?? '';
    $pass = $_POST['password'] ?? '';
    if ($user && $pass) {
        $stmt = $mysqli->prepare("SELECT id, password FROM admins WHERE username = ? LIMIT 1");
        $stmt->bind_param('s', $user);
        $stmt->execute();
        $res = $stmt->get_result()->fetch_assoc();
        if ($res && password_verify($pass, $res['password'])) {
            $_SESSION['admin_id'] = $res['id'];
            header('Location: dashboard.php');
            exit;
        } else {
            $err = 'Invalid credentials';
        }
    } else {
        $err = 'Enter username & password';
    }
}
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Admin Login</title>
<link rel="stylesheet" href="../public/assets/css/style.css">
</head><body class="admin-login">
  <main class="container">
    <form method="post" class="auth-form">
      <h2>Admin Login</h2>
      <?php if($err) echo '<p class="error">'.e($err).'</p>'; ?>
      <label>Username<input name="username"></label>
      <label>Password<input name="password" type="password"></label>
      <button type="submit">Login</button>
    </form>
  </main>
</body></html>
