<?php
// admin/edit_car.php
require_once __DIR__ . '/../inc/config.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/functions.php';
require_admin();
$mysqli = get_db();
$id = intval($_GET['id'] ?? 0);
if (!$id) { header('Location: dashboard.php'); exit; }
$stmt = $mysqli->prepare("SELECT * FROM cars WHERE id = ? LIMIT 1");
$stmt->bind_param('i', $id); $stmt->execute();
$car = $stmt->get_result()->fetch_assoc();
if (!$car) { header('Location: dashboard.php'); exit; }

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf'] ?? '')) { $err = 'Invalid token'; }
    else {
        $title = $_POST['title']; $brand = $_POST['brand']; $model = $_POST['model'];
        $year = intval($_POST['year']); $mileage = intval($_POST['mileage']); $price = floatval($_POST['price']);
        $condition = $_POST['condition']; $seller = $_POST['seller_type']; $description = $_POST['description'];
        $is_hot = isset($_POST['is_hot'])?1:0; $is_featured = isset($_POST['is_featured'])?1:0;

        $s = $mysqli->prepare("UPDATE cars SET title=?, brand=?, model=?, year=?, mileage=?, price=?, condition=?, seller_type=?, description=?, is_hot_deal=?, is_featured=? WHERE id=?");
        $s->bind_param('sssiiisssiii', $title, $brand, $model, $year, $mileage, $price, $condition, $seller, $description, $is_hot, $is_featured, $id);
        if ($s->execute()) {
            // handle images
            if (!empty($_FILES['images'])) {
                $uploaded = validate_and_upload_images($_FILES['images'], $id);
                foreach ($uploaded as $k => $fname) {
                    $is_primary = ($k===0) ? 1 : 0;
                    $ins = $mysqli->prepare("INSERT INTO car_images (car_id, filename, is_primary) VALUES (?,?,?)");
                    $ins->bind_param('isi', $id, $fname, $is_primary);
                    $ins->execute();
                }
            }
            header('Location: dashboard.php');
            exit;
        } else {
            $err = 'Update failed: ' . $mysqli->error;
        }
    }
}
$token = generate_csrf_token();

// fetch images
$imgs = $mysqli->prepare("SELECT id, filename FROM car_images WHERE car_id=?");
$imgs->bind_param('i',$id); $imgs->execute();
$imgs = $imgs->get_result()->fetch_all(MYSQLI_ASSOC);
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Edit Car</title>
<link rel="stylesheet" href="../public/assets/css/style.css">
</head><body>
<?php include 'inc/header.php'; ?>
<main class="container">
  <h2>Edit Car #<?php echo e($car['id']); ?></h2>
  <?php if($err) echo '<p class="error">'.e($err).'</p>'; ?>
  <form method="post" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="<?php echo $token; ?>">
    <label>Title<input name="title" value="<?php echo e($car['title']); ?>" required></label>
    <label>Brand<input name="brand" value="<?php echo e($car['brand']); ?>" required></label>
    <label>Model<input name="model" value="<?php echo e($car['model']); ?>" required></label>
    <label>Year<input name="year" type="number" value="<?php echo e($car['year']); ?>" required></label>
    <label>Mileage<input name="mileage" type="number" value="<?php echo e($car['mileage']); ?>"></label>
    <label>Price<input name="price" type="number" step="0.01" value="<?php echo e($car['price']); ?>" required></label>
    <label>Condition
      <select name="condition">
        <option <?php if($car['condition']=='Used') echo 'selected'; ?>>Used</option>
        <option <?php if($car['condition']=='New') echo 'selected'; ?>>New</option>
        <option <?php if($car['condition']=='Certified') echo 'selected'; ?>>Certified</option>
      </select>
    </label>
    <label>Seller Type
      <select name="seller_type">
        <option <?php if($car['seller_type']=='Private') echo 'selected'; ?>>Private</option>
        <option <?php if($car['seller_type']=='Company') echo 'selected'; ?>>Company</option>
      </select>
    </label>
    <label>Description<textarea name="description"><?php echo e($car['description']); ?></textarea></label>

    <div class="existing-images">
      <?php foreach($imgs as $im): ?>
        <div class="img-wrap">
          <img src="../public/assets/uploads/<?php echo e($im['filename']); ?>" alt="">
          <a href="delete_image.php?id=<?php echo $im['id']; ?>&car=<?php echo $car['id']; ?>" onclick="return confirm('Delete image?')">Delete</a>
        </div>
      <?php endforeach; ?>
    </div>

    <label>Upload new images<input name="images[]" type="file" multiple accept="image/*"></label>
    <label><input type="checkbox" name="is_hot" <?php if($car['is_hot_deal']) echo 'checked'; ?>> Hot deal</label>
    <label><input type="checkbox" name="is_featured" <?php if($car['is_featured']) echo 'checked'; ?>> Featured</label>
    <button type="submit">Update</button>
  </form>
</main>
<?php include 'inc/footer.php'; ?>
</body></html>
