<?php
// admin/add_car.php
require_once __DIR__ . '/../inc/config.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/functions.php';
require_admin();
$mysqli = get_db();
$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf'] ?? '')) {
        $err = 'Invalid request token';
    } else {
        $title = $_POST['title'] ?? '';
        $brand = $_POST['brand'] ?? '';
        $model = $_POST['model'] ?? '';
        $year = intval($_POST['year'] ?? 0);
        $mileage = intval($_POST['mileage'] ?? 0);
        $price = floatval($_POST['price'] ?? 0);
        $condition = $_POST['condition'] ?? 'Used';
        $seller = $_POST['seller_type'] ?? 'Private';
        $description = $_POST['description'] ?? '';
        $is_hot = isset($_POST['is_hot']) ? 1 : 0;
        $is_featured = isset($_POST['is_featured']) ? 1 : 0;

        $stmt = $mysqli->prepare("INSERT INTO cars (title, brand, model, year, mileage, price, condition, seller_type, description, is_hot_deal, is_featured) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('sssiiisssii', $title, $brand, $model, $year, $mileage, $price, $condition, $seller, $description, $is_hot, $is_featured);
        if ($stmt->execute()) {
            $car_id = $stmt->insert_id;
            // handle images
            if (!empty($_FILES['images'])) {
                $uploaded = validate_and_upload_images($_FILES['images'], $car_id);
                foreach ($uploaded as $k => $fname) {
                    $is_primary = ($k===0) ? 1 : 0;
                    $s2 = $mysqli->prepare("INSERT INTO car_images (car_id, filename, is_primary) VALUES (?,?,?)");
                    $s2->bind_param('isi', $car_id, $fname, $is_primary);
                    $s2->execute();
                }
            }
            header('Location: dashboard.php');
            exit;
        } else {
            $err = 'Save failed: ' . $mysqli->error;
        }
    }
}
$token = generate_csrf_token();
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Add Car</title>
<link rel="stylesheet" href="../public/assets/css/style.css">
</head><body>
<?php include 'inc/header.php'; ?>
<main class="container">
  <h2>Add Car</h2>
  <?php if($err) echo '<p class="error">'.e($err).'</p>'; ?>
  <form method="post" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="<?php echo $token; ?>">
    <label>Title<input name="title" required></label>
    <label>Brand<input name="brand" required></label>
    <label>Model<input name="model" required></label>
    <label>Year<input name="year" type="number" required></label>
    <label>Mileage<input name="mileage" type="number"></label>
    <label>Price<input name="price" type="number" step="0.01" required></label>
    <label>Condition
      <select name="condition">
        <option>Used</option><option>New</option><option>Certified</option>
      </select>
    </label>
    <label>Seller Type
      <select name="seller_type">
        <option>Private</option><option>Company</option>
      </select>
    </label>
    <label>Description<textarea name="description"></textarea></label>
    <label>Images (multiple)
      <input name="images[]" type="file" multiple accept="image/*">
    </label>
    <label><input type="checkbox" name="is_hot"> Hot deal</label>
    <label><input type="checkbox" name="is_featured"> Featured</label>
    <button type="submit">Save</button>
  </form>
</main>
<?php include 'inc/footer.php'; ?>
</body></html>
